/* this file define all teh integer values corresponse with 
 * each type of token.
 */
%{
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <string>

using namespace std;
extern int yyline;
ofstream outfile;

struct xxx {
  int v;
  string s;
} w[10000];

int wnum=0;

void yyerror(const char * str);
int yyparse();
%}


/* a simple calculator */

%union {
  int sv;
}

%token   EOFnumber             0
%token   STRINGCONST           1
%token   <sv> INTEGERCONST          2
%token   CHARCONST             3
%token   PLUSNUM               4
%token   TIMESNUM              5
%token   IFNUM                 6
%token   THENNUM               7
%token   ELSENUM               8
%token   EQUALNUM              9
%token   IDNUM                 10
%token   LPARENNUM             11
%token   RPARENNUM             12
%token   SEMINUM               14
%token   BEGINNUM              17
%token   ENDNUM                18


%type <sv> exp
%type <sv> term
%type <sv> item

%%   /* specification */

program: BEGINNUM {print_header();} explist ENDNUM {print_end();}

explist: exp {cout << w[$1].v << "\n"; print_exp(w[$1].s);}
       | exp {cout << w[$1].v << "\n"; print_exp(w[$1].s);} SEMINUM explist

exp : exp PLUSNUM term
{ $$ = wnum++;
  w[$$].v = w[$1].v + w[$3].v;
  w[$$].s = w[$1].s + '+' +  w[$3].s;
}
    | term
{ $$ = wnum++;
  w[$$].v = w[$1].v;
  w[$$].s = w[$1].s;
}
    ;
term : term TIMESNUM item
{$$=wnum++;
w[$$].v = w[$1].v * w[$3].v;
w[$$].s = '(' + w[$1].s + ')' + '*' + '(' + w[$3].s + ')';
}
     | item
{$$ = wnum++;
 w[$$].v = w[$1].v; w[$$].s = w[$1].s;}
     ;
item : LPARENNUM exp RPARENNUM
{$$ = wnum++;
 w[$$].v = w[$2].v; 
 w[$$].s = w[$2].s;}
    | INTEGERCONST
{$$ = wnum++;
 w[$$].v = $1; 
w[$$].s = convertInt($1);}
    ;
%%


#include "lex.yy.c"
#include <stdio.h>


void print_header()
{
  outfile.open("mya.cpp");
  outfile << "#include <iostream>\n";
  outfile << "#include <stdio.h>\n";
  outfile << "using namespace std;\n";
  outfile << "\nmain()\n";
  outfile << "{\n";
}

void print_end()
{
  outfile << "}\n";
  outfile.close();
}

void print_exp(string s)
{
  outfile << "  cout << " << s << " << \"\\n\";\n";
}

string convertInt(int num)
{
  char t[1000];
  sprintf(t, "%d", num);
  
  string r(t);
  return r;
}

void yyerror(const char * str)
{    printf("yyerror: %s at line %d\n", str, yyline);
}


main()
{
  if (!yyparse()) {printf("accept\n");}
  else printf("reject\n");
}    









