#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>

int main(int argc, char* argv[])
{
  int pid;
  int stat;

  if (argc < 2) 
  {
    fprintf(stderr, "USAGE: %s command\n", *argv);
    exit(-1);
  }

  if (fork() == 0) /* Child */
  {
    if (execv(argv[1], argv+1) == -1) 
      exit(-1); /* execv unsuccessful */
    else 
      printf("This is not printed\n");
  } 
  else /* Parent */
  {
    pid = wait(&stat);
    if(WIFEXITED(stat) && !WEXITSTATUS(stat))
      printf("child pid = %d, status = %d\n", pid, WEXITSTATUS(stat));
    else 
      printf("command failed\n");
  }

  return 0;
}
