#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>


int main(int argc, char **argv)
{
  char **pptr;
  struct servent *sptr;

  if (argc < 2) 
  {
    fprintf(stderr,"USAGE: %s service [protocol].\n", argv[0]);
    exit(-1);
  }
  
  if ((sptr = getservbyname(argv[1], argv[2])) == 0) 
  {
    fprintf(stderr,"getservbyname error: h_errno = %d\n", h_errno);
    exit(-1);
  }

  printf("Official service name: %s, port = %d, protocol = %s\n", 
          sptr->s_name, ntohs(sptr->s_port), sptr->s_proto);

  printf("\tAlias:\n");
  for(pptr = sptr->s_aliases; *pptr; pptr++) 
    printf("\t\t%s\n", *pptr);
  

  return 0;
}
