#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/utsname.h>


int main()
{
  struct hostent *hptr;
  struct utsname myname;
  char mychname[100];

  if (uname(&myname) < 0) 
  {
    perror("uname");
    exit(-1);
  }

  if ((hptr = gethostbyname(myname.nodename)) == 0) 
  {
    fprintf(stderr,"gethostbyname error: h_errno = %d\n", h_errno);
    exit(-1);
  }


  printf("Official name from gethostbyname: %s\n", hptr->h_name);
  if (gethostname(mychname, 100) < 0) 
  {
    perror("gethostname");
    exit(-1);
  }

  printf("Name from gethostname = %s\n", mychname);

  return 0;
}





