#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <sys/time.h>


int main(int argc, char **argv)
{
  struct hostent *hptr;
  struct timeval start, end;

  if (argc < 2) 
  {
    fprintf(stderr,"USAGE: %s hostname.\n", argv[0]);
    exit(-1);
  }
  
  gettimeofday(&start, NULL);

  if ((hptr = gethostbyname(argv[1])) == 0) 
  {
    fprintf(stderr,"gethostbyname error: h_errno = %d\n", h_errno);
    exit(-1);
  }

  gettimeofday(&end, NULL);

  printf("Official hostname: %s\n", hptr->h_name);
  printf("gethostbyname takes %10.5f ms\n", (end.tv_sec-start.tv_sec)*1000.0
	 + (end.tv_usec - start.tv_usec) / 1000.0);

  return 0;
}
