#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>


int main(int argc, char **argv)
{
  char **pptr, addr[INET_ADDRSTRLEN];
  struct hostent *hptr;

  if (argc < 2) 
  {
    fprintf(stderr,"USAGE: %s hostname.\n", argv[0]);
    exit(-1);
  }
  
  if ((hptr = gethostbyname(argv[1])) == 0) 
  {
    fprintf(stderr,"gethostbyname error: h_errno = %d\n", h_errno);
    exit(-1);
  }

  printf("Official hostname: %s\n", hptr->h_name);
  for(pptr = hptr->h_aliases; *pptr; pptr++) 
    printf("\tAlias: %s\n", *pptr);

  switch(hptr->h_addrtype) 
  {
  case AF_INET: /* AF_INET6 can be added, if available; increase addr size */

    for (pptr = hptr->h_addr_list; *pptr; pptr++) 
      printf("\tAddress: %s\n", inet_ntop(hptr->h_addrtype, *pptr, addr, 
	     sizeof (addr))); 
    break;

  default:
    fprintf(stderr,"Unknown address type\n");
  }

  return 0;
}
