#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#define BUFLEN 500

static const double PiValue[3] = {3.141, 3.1415, 3.14159};
static int LastVersion = 0;
static char *VersionPrefix=NULL;
static const int Argument=1000;
static char *IP, *Port;
#define OLDVERSION 0
#define NEWVERSION 1
#define ERROR1 2
#define ERROR2 3
#define ERROR3 4
#define ERROR4 5
#define ERROR5 6



  
int OpenSocket()
{
  int sockfd;
  struct sockaddr_in addr;

  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) 
  {
    perror("socket");
    exit(1);
  }

  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(atoi(Port));
  inet_pton(AF_INET, IP, &addr.sin_addr);

  if (connect(sockfd, (struct sockaddr *)&addr, sizeof(addr)) < 0) 
  {
    perror("connect");
    exit(1);
  }

  return sockfd;
}


void CloseSocket(int socketfd)
{
  close(socketfd);
  return;
}


void  ReceiveResponse(int sfd, char *buf2, int size)
{
  int length, total=0, done=0;
  
  while (!done)
  {
    length=read(sfd,buf2+total,size-1-total);
    if(length==0)
    {
      fprintf(stderr,"Server closed connection after sending %d bytes\n", total);
      done = 1;
    }
    else if(length < 0)
    {
      perror("read");
      exit(1);
    }
    
    total += length;
    buf2[total] = '\0';
    
    if(strstr(buf2,"#@#ENDERROR") || strstr(buf2,"#@#ENDRESULT") || strstr(buf2,"#@#ENDDEFINEFUNCTION"))
      done = 1;
  }
  
}


int CheckResponse(int Criterion, char *buf, int size)
{
  char correct[BUFLEN], buf1[100], buf2[100];
  float temp;
  
  switch(Criterion)
  {
  case NEWVERSION:
    sprintf(correct, "#@#DEFINEFUNCTION newpi %s.%d #@#ENDDEFINEFUNCTION", VersionPrefix, LastVersion);
    break;
  case OLDVERSION:
    sscanf(buf,"%s %f %s", buf1, &temp, buf2);
    if(strcmp(buf1,"#@#RESULT") || strcmp(buf2,"#@#ENDRESULT") || fabs(temp-PiValue[LastVersion%3])>0.000001)
    {
      sprintf(correct, "#@#RESULT %f #@#ENDRESULT", PiValue[LastVersion%3]);
      break;
    }
    printf("VALID server response: \"%s\"\n", buf);
    return 1;
  case ERROR1: case ERROR2: case ERROR3:
    sprintf(correct, "#@#ERROR Invalid request #@#ENDERROR");
    break;
  case ERROR4: case ERROR5:
    sprintf(correct, "#@#ERROR Invalid definition #@#ENDERROR");
    break;
  default:
    fprintf(stderr, "INVALID criterion: %d in CheckResponse()\n", Criterion);
    break;
  }
  
  if(strncmp(buf, correct, BUFLEN))
   {
     fprintf(stderr, "INVALID server response: \"%s\"\n", buf);
     fprintf(stderr, "\tinstead of: \"%s\"\n", correct);
     
     return 0;
   }
  else
  {
    printf("VALID server response: \"%s\"\n", buf);
    return 1;
  }
  
}



void SendPiRequest(int sfd, int Type)
{
  char filename[BUFLEN], buf[BUFLEN], temp[BUFLEN];
  int fd, length;
  
  if(Type==NEWVERSION)
  {
    sprintf(filename,"newpi%d.c", LastVersion%3);
    if((fd=open(filename,O_RDONLY))==-1)
    {
      fprintf(stderr,"ERROR: Unable to open file %s ... exiting\n", filename);
      exit(-1);
    }

    printf("Press enter to continue\n");
    fgets(temp,BUFLEN,stdin);
    fgets(temp,BUFLEN,stdin);
    
    write(sfd,"#@#FUNCTIONDEFINITION ", strlen("#@#FUNCTIONDEFINITION ")); 
    printf("Press enter again to continue\n");
    fgets(temp,BUFLEN,stdin);
    while((length = read(fd,buf,BUFLEN)))
    {
      if(length<0)
      {
	perror("read");
	exit(1);
      }
      
      write(sfd,buf,length);
    }
    
    printf("Press enter once again to continue\n");
    fgets(temp,BUFLEN,stdin);

    write(sfd," #@#ENDFUNCTIONDEFINITION", strlen(" #@#ENDFUNCTIONDEFINITION")); 
    
    close(fd);
  }
  else
  {
    sprintf(buf,"#@#COMPUTE newpi %s.%d %d #@#ENDCOMPUTE", VersionPrefix, LastVersion, Argument);
    fprintf(stderr,"\t sending %s\n", buf);
    
    write(sfd, buf, strlen(buf)); 
  }
}



void SendErrorRequest(int sfd, int Type)
{
  char buf[BUFLEN];
  
  switch(Type)
  {
  case ERROR1:
    sprintf(buf,"#@#FUNCTIONDEFINITION newpi %s.%d %d #@#ENDFUNCTIONDEFINITION", VersionPrefix, LastVersion, Argument);
    write(sfd, buf, strlen(buf)); 
    break;
  case ERROR2:
    sprintf(buf,"#@#COMPUTE newpi %s.%d #@#ENDCOMPUTE", VersionPrefix, LastVersion);
    write(sfd, buf, strlen(buf)); 
    break;
  case ERROR3:
    sprintf(buf,"#@#COMPUTE newpi %s.%d abc #@#ENDCOMPUTE", VersionPrefix, LastVersion);
    write(sfd, buf, strlen(buf)); 
    break;
  case ERROR4:
    sprintf(buf,"#@#COMPUTE newpi(int N){} #@#ENDCOMPUTE");
    write(sfd, buf, strlen(buf)); 
    break;
  case ERROR5:
    sprintf(buf,"#@#FUNCTIONDEFINITION #@#ENDFUNCTIONDEFINITION");
    write(sfd, buf, strlen(buf)); 
    break;
  }
  
}



void CheckError(int ErrorType)
{
  int sfd;
  char buf2[BUFLEN];

  sfd = OpenSocket();

  if(ErrorType==ERROR4 || ErrorType==ERROR5)
  {
    LastVersion++;
    SendPiRequest(sfd,OLDVERSION);
    ReceiveResponse(sfd, buf2, BUFLEN);
    CheckResponse(NEWVERSION,buf2,BUFLEN);
    LastVersion--;
  }
  
  SendErrorRequest(sfd,ErrorType);
  ReceiveResponse(sfd, buf2, BUFLEN);
  
  CheckResponse(ErrorType,buf2,BUFLEN);
  
  CloseSocket(sfd);

  return;
} 
 

void CheckPi(int VersionType)
{
  int sfd;
  char buf2[BUFLEN];

  
  if(LastVersion==0 && VersionType==OLDVERSION)
  {
    fprintf(stderr, "INVALID version: You must initially request a new version\n");
    return;
  }
  
  if(VersionType==NEWVERSION)
    LastVersion++;

  printf("\t opening socket \n");
  sfd = OpenSocket();
  printf("\t opened socket \n");
  
  printf("\t sending request \n");
  SendPiRequest(sfd,OLDVERSION);
  printf("\t sent request \n");
  printf("\t receiving response \n");
  ReceiveResponse(sfd, buf2, BUFLEN);
  printf("\t received response \n");
  
  if(VersionType==NEWVERSION)
  {
    if(!CheckResponse(NEWVERSION,buf2,BUFLEN))
    {
      CloseSocket(sfd); 
      return;
    }
    
    SendPiRequest(sfd,NEWVERSION);
    ReceiveResponse(sfd, buf2, BUFLEN);
  }
  
  CheckResponse(OLDVERSION,buf2,BUFLEN);
  
  CloseSocket(sfd);

  return;
} 



void SendPi()
{
  int option;
  
  scanf("%d", &option);
  
  if(option==OLDVERSION || option == NEWVERSION)
    CheckPi(option);
  else
    fprintf(stderr, "INVALID option %d\n", option);
}


void SendError()
{
  int option;
  
  scanf("%d", &option);
  
  if(option==0 || option == 1 || option==2 || option == 3 || option==4 )
    CheckError(option+2);
  else
    fprintf(stderr, "INVALID option %d\n", option);
}



int ProcessCommand()
{
  int command;
  
  scanf("%d", &command);
  
  switch(command)
  {
  case 1:
    SendPi();
    break;
  case 2:
    SendError();
    break;
  case 0:
    return 0;
    break;
  default:
    fprintf(stderr, "INVALID command %d\n", command);
    break;
  }

  return 1;
}


int main(int argc, char * argv[])
{

  if (argc != 4) 
  {
    fprintf(stderr,"USAGE: %s ip_addr port VersionPrefix.\n", argv[0]);
    exit(-1);
  }

  IP = argv[1];
  Port = argv[2];
  VersionPrefix = argv[3];
  
  while(ProcessCommand())
    ;
  


  return 0;
}




